﻿using System;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.GetConsults
{
    /// <summary>
    /// Get integration settings step.
    /// </summary>
    public class GetIntegrationSettingsStep : FilterBase<GetConsultsStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(GetConsultsStateObject state)
        {
            try
            {
                const string fakeResponseString = "Vista - Get Consult Fake Response Type";

                using (var service = new Xrm(state.OrganizationServiceProxy))
                {
                    var healthShareFakeResponse = service.mcs_integrationsettingSet.FirstOrDefault(i => i.mcs_name == fakeResponseString);
                    state.ConsultsFakeResponseType = healthShareFakeResponse == null ? string.Empty : healthShareFakeResponse.mcs_value;
                }
            }
            catch (Exception ex)
            {
                throw new Exception($"HealthShare Get Consults GetIntegrationSettingsStep Pipeline Error: {ex.Message}", ex.InnerException);
            }
        }
    }
}